/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetOrc;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.fac.LOTRFaction;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityStonefoot
extends LOTREntityDwarf {
    public LOTREntityStonefoot(World world) {
        super(world);
        this.familyInfo.marriageEntityClass = LOTREntityStonefoot.class;
        this.familyInfo.marriageAchievement = LOTRAchievement.marryMornaugrimDwarf;
        this.addTargetTasks(true, LOTREntityAINearestAttackableTargetOrc.class);
    }

    @Override
    protected LOTRFoods getDwarfFoods() {
        return LOTRFoods.DWARF;
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.daggerRed));
        this.npcItemsInv.setIdleItem(null);
        return data;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.RED_MOUNTAINS;
    }

    @Override
    protected Item getDwarfSteelDrop() {
        return LOTRMod.dwarfSteel;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killRedDwarf;
    }

    @Override
    public float getAlignmentBonus() {
        return 1.0f;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int bones = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(LOTRMod.dwarfBone, 1);
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.dropChestContents(this.getLarderDrops(), 1, 2 + i);
        }
        if (this.field_70146_Z.nextInt(8) == 0) {
            this.dropChestContents(this.getGenericDrops(), 1, 2 + i);
        }
        if (flag) {
            int rareDropChance = 20 - i * 4;
            if (this.field_70146_Z.nextInt(rareDropChance = Math.max(rareDropChance, 1)) == 0) {
                int randDrop = this.field_70146_Z.nextInt(4);
                switch (randDrop) {
                    case 0: {
                        this.func_70099_a(new ItemStack(Items.field_151042_j), 0.0f);
                        break;
                    }
                    case 1: {
                        this.func_70099_a(new ItemStack(this.getDwarfSteelDrop()), 0.0f);
                        break;
                    }
                    case 2: {
                        this.func_70099_a(new ItemStack(Items.field_151074_bl, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                        break;
                    }
                    case 3: {
                        this.func_70099_a(new ItemStack(LOTRMod.silverNugget, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                    }
                }
            }
            int mithrilBookChance = 40 - i * 5;
            if (this.field_70146_Z.nextInt(mithrilBookChance = Math.max(mithrilBookChance, 1)) == 0) {
                this.func_70099_a(new ItemStack(LOTRMod.mithrilBook), 0.0f);
            }
        }
    }

    @Override
    protected LOTRChestContents getLarderDrops() {
        return LOTRChestContents.LOTRChestContents2.REDDWARF_SMITHY;
    }

    @Override
    protected LOTRChestContents getGenericDrops() {
        return LOTRChestContents.LOTRChestContents2.REDDWARFTOWER;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "stonefoot/dwarf/hired";
            }
            return this.func_70631_g_() ? "stonefoot/child/friendly" : "stonefoot/dwarf/friendly";
        }
        return this.func_70631_g_() ? "stonefoot/child/hostile" : "stonefoot/dwarf/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.REDMOUNTAINS.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.REDMOUNTAINS;
    }
}

